/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class NetherPortalMatcher {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static boolean isAir(class_1936 world, class_2338 pos) {
        return world.method_22347(pos);
    }

    static IntBox findVerticalPortalPlacement(class_2338 areaSize, class_1936 world, class_2338 searchingCenter) {
        int maxY = McHelper.getMaxContentYExclusive(world);
        int minY = McHelper.getMinY(world);
        IntBox airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new class_2338(6, 0, 6), world, searchingCenter, 8, true, 64, maxY);
        if (airCube == null) {
            airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new class_2338(2, 0, 2), world, searchingCenter, 10, true, 64, maxY);
        }
        if (airCube == null) {
            airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new class_2338(2, 0, 2), world, searchingCenter, 10, false, minY, maxY);
        }
        if (airCube == null) {
            LOGGER.info("Cannot Find Portal Placement on Solid Surface");
            return null;
        }
        if (world.method_8320(airCube.l.method_10074()).method_51367()) {
            LOGGER.info("Generated Portal On Ground");
            return NetherPortalMatcher.pushDownBox(world, airCube.getSubBoxInCenter(areaSize));
        }
        LOGGER.info("Generated Portal On Non Solid Surface");
        return NetherPortalMatcher.levitateBox(world, airCube.getSubBoxInCenter(areaSize), 40);
    }

    private static IntBox expandFromBottomCenter(IntBox box, class_2338 spacing) {
        class_2338 boxSize = box.getSize();
        return box.getAdjusted(-spacing.method_10263() / 2, 0, -spacing.method_10260() / 2, spacing.method_10263() / 2, spacing.method_10264(), spacing.method_10260() / 2);
    }

    private static IntBox getAirCubeOnGround(class_2338 areaSize, class_2338 ambientSpaceReserved, class_1936 world, class_2338 searchingCenter, int findingRadius, boolean solidGround, int startY, int endY) {
        Predicate<class_2338> isAirOnGroundPredicate = blockPos -> solidGround ? NetherPortalMatcher.isAirOnSolidGround(world, blockPos) : NetherPortalMatcher.isAirOnGround(world, blockPos);
        return BlockTraverse.searchColumned(searchingCenter.method_10263(), searchingCenter.method_10260(), findingRadius, startY, endY, mutable -> {
            IntBox box;
            IntBox expanded;
            if (isAirOnGroundPredicate.test((class_2338)mutable) && NetherPortalMatcher.isAirCubeMediumPlace(world, expanded = NetherPortalMatcher.expandFromBottomCenter(box = IntBox.fromBasePointAndSize(mutable, areaSize), ambientSpaceReserved))) {
                if (solidGround) {
                    if (BlockTraverse.boxAllMatch(box.getSurfaceLayer(class_2350.field_11033), isAirOnGroundPredicate) && isAirOnGroundPredicate.test(expanded.l)) {
                        return box;
                    }
                } else {
                    return box;
                }
            }
            return null;
        });
    }

    static IntBox findHorizontalPortalPlacement(class_2338 areaSize, class_1936 world, class_2338 searchingCenter) {
        IntBox result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 30, 12);
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 10, 12);
        }
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 1, 12);
        }
        return result;
    }

    private static IntBox findHorizontalPortalPlacementWithVerticalSpaceReserved(class_2338 areaSize, class_1936 world, class_2338 searchingCenter, int verticalSpaceReserve, int findingRadius) {
        class_2338 growVertically = new class_2338(areaSize.method_10263(), verticalSpaceReserve, areaSize.method_10260());
        IntBox foundCubeArea = NetherPortalMatcher.findCubeAirAreaAtAnywhere(growVertically, world, searchingCenter, findingRadius);
        if (foundCubeArea == null) {
            return null;
        }
        return foundCubeArea.getSubBoxInCenter(areaSize);
    }

    public static boolean isSolidGroundBlock(class_2680 blockState) {
        return blockState.method_51367();
    }

    public static boolean isGroundBlock(class_2680 blockState) {
        return !blockState.method_26215();
    }

    private static boolean isAirOnSolidGround(class_1936 world, class_2338 blockPos) {
        return world.method_22347(blockPos) && NetherPortalMatcher.isSolidGroundBlock(world.method_8320(blockPos.method_10069(0, -1, 0)));
    }

    private static boolean isAirOnGround(class_1936 world, class_2338 blockPos) {
        return world.method_22347(blockPos) && NetherPortalMatcher.isGroundBlock(world.method_8320(blockPos.method_10069(0, -1, 0)));
    }

    public static IntBox findCubeAirAreaAtAnywhere(class_2338 areaSize, class_1936 world, class_2338 searchingCenter, int findingRadius) {
        return BlockTraverse.searchColumned(searchingCenter.method_10263() - areaSize.method_10263() / 2, searchingCenter.method_10260() - areaSize.method_10260() / 2, findingRadius, 1 + McHelper.getMinY(world), McHelper.getMaxYExclusive(world) - 1, mutable -> {
            IntBox box = IntBox.fromBasePointAndSize(mutable, areaSize);
            if (NetherPortalMatcher.isAirCubeMediumPlace(world, box)) {
                return box;
            }
            return null;
        });
    }

    public static boolean isAirCubeMediumPlace(class_1936 world, IntBox box) {
        if (box.h.method_10264() + 1 >= McHelper.getMaxContentYExclusive(world)) {
            return false;
        }
        if (box.l.method_10264() - 1 <= McHelper.getMinY(world)) {
            return false;
        }
        return NetherPortalMatcher.isAllAir(world, box);
    }

    public static boolean isAllAir(class_1936 world, IntBox box) {
        boolean roughTest = Arrays.stream(box.getEightVertices()).allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
        if (!roughTest) {
            return false;
        }
        return box.stream().allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
    }

    public static IntBox levitateBox(class_1936 world, IntBox airCube, int maxOffset) {
        Integer maxUpShift = Helper.getLastSatisfying(IntStream.range(1, maxOffset * 3 / 2).boxed(), upShift -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new class_2382(0, upShift.intValue(), 0))));
        if (maxUpShift == null) {
            maxUpShift = 0;
        }
        return airCube.getMoved(new class_2382(0, maxUpShift * 2 / 3, 0));
    }

    public static IntBox pushDownBox(class_1936 world, IntBox airCube) {
        Integer downShift = Helper.getLastSatisfying(IntStream.range(0, 40).boxed(), i -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new class_2382(0, -i.intValue(), 0))));
        if (downShift == null) {
            downShift = 0;
        }
        return airCube.getMoved(new class_2382(0, -downShift.intValue(), 0));
    }
}

